/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.module.StructureProcessorModule;
import com.yungnickyoung.minecraft.betterdeserttemples.world.ItemFrameChances;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ItemFrameProcessor
extends StructureProcessor {
    public static final ItemFrameProcessor INSTANCE = new ItemFrameProcessor();
    public static final Codec<StructureProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader levelReader, BlockPos structurePiecePos, StructureTemplate.StructureEntityInfo localEntityInfo, StructureTemplate.StructureEntityInfo globalEntityInfo, StructurePlaceSettings structurePlaceSettings, StructureTemplate template) {
        if (globalEntityInfo.f_74685_.m_128461_("id").equals("minecraft:item_frame")) {
            String item;
            RandomSource randomSource = structurePlaceSettings.m_230326_(globalEntityInfo.f_74684_);
            try {
                item = globalEntityInfo.f_74685_.m_128469_("Item").m_128423_("id").toString();
            }
            catch (Exception e) {
                BetterDesertTemplesCommon.LOGGER.info("Unable to randomize item frame at {}", (Object)globalEntityInfo.f_74684_);
                return globalEntityInfo;
            }
            globalEntityInfo.f_74685_.m_128405_("TileX", globalEntityInfo.f_74684_.m_123341_());
            globalEntityInfo.f_74685_.m_128405_("TileY", globalEntityInfo.f_74684_.m_123342_());
            globalEntityInfo.f_74685_.m_128405_("TileZ", globalEntityInfo.f_74684_.m_123343_());
            if (item.equals("\"minecraft:iron_sword\"")) {
                randomItemString = ForgeRegistries.ITEMS.getKey((Object)ItemFrameChances.get().getArmouryItem(randomSource)).toString();
                if (!randomItemString.equals("minecraft:air")) {
                    globalEntityInfo.f_74685_.m_128469_("Item").m_128359_("id", randomItemString);
                }
            } else if (item.equals("\"minecraft:bread\"")) {
                randomItemString = ForgeRegistries.ITEMS.getKey((Object)ItemFrameChances.get().getStorageItem(randomSource)).toString();
                if (!randomItemString.equals("minecraft:air")) {
                    globalEntityInfo.f_74685_.m_128469_("Item").m_128359_("id", randomItemString);
                }
            } else {
                return globalEntityInfo;
            }
            int randomRotation = randomSource.m_188503_(8);
            globalEntityInfo.f_74685_.m_128344_("ItemRotation", (byte)randomRotation);
        }
        return globalEntityInfo;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorModule.ITEM_FRAME_PROCESSOR;
    }
}

