/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.mixin;

import com.github.nyuppo.MoreMobVariants;
import com.github.nyuppo.config.Variants;
import com.github.nyuppo.variant.MobVariant;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Spider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpiderRenderer.class})
public class SpiderRendererMixin {
    private static final ResourceLocation DEFAULT = new ResourceLocation("textures/entity/spider/spider.png");

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/monster/Spider;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetTextureLocation(Spider spiderEntity, CallbackInfoReturnable<ResourceLocation> ci) {
        Object variant;
        CompoundTag nbt = new CompoundTag();
        spiderEntity.m_20240_(nbt);
        if (nbt.m_128441_("VariantID")) {
            variant = nbt.m_128461_("VariantID");
            if (((String)variant).equals(MoreMobVariants.id("default").toString()) || ((String)variant).isEmpty()) {
                ci.setReturnValue((Object)DEFAULT);
            } else {
                String[] split = Variants.splitVariant((String)variant);
                ci.setReturnValue((Object)new ResourceLocation(split[0], "textures/entity/spider/" + split[1] + ".png"));
            }
        }
        if (spiderEntity.m_8077_() && (variant = Variants.getVariantFromNametag(EntityType.f_20479_, spiderEntity.m_7755_().getString())) != null) {
            ResourceLocation identifier = ((MobVariant)variant).getIdentifier();
            ci.setReturnValue((Object)new ResourceLocation(identifier.m_135827_(), "textures/entity/spider/" + identifier.m_135815_() + ".png"));
        }
    }
}

