/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.upload.download.downloader;

import by.gdev.http.download.handler.PostHandler;
import by.gdev.http.download.model.Headers;
import by.gdev.util.DesktopUtil;
import by.gdev.util.model.download.Metadata;
import by.gdev.util.model.download.Repo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloaderContainer {
    private static final Logger log = LoggerFactory.getLogger(DownloaderContainer.class);
    String destinationRepositories;
    long containerSize;
    Repo repo;
    List<PostHandler> handlers;

    public void filterNotExistResoursesAndSetRepo(Repo repo, String workDirectory) throws NoSuchAlgorithmException, IOException {
        this.repo = new Repo();
        ArrayList<Metadata> listRes = new ArrayList<Metadata>();
        for (Metadata meta : repo.getResources()) {
            File localFile = Paths.get(workDirectory, meta.getPath()).toAbsolutePath().toFile();
            if (localFile.exists()) {
                String shaLocalFile = DesktopUtil.getChecksum(localFile, Headers.SHA1.getValue());
                BasicFileAttributes attr = Files.readAttributes(localFile.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                if (!(!attr.isSymbolicLink() & !shaLocalFile.equals(meta.getSha1()))) continue;
                listRes.add(meta);
                log.warn("The hash sum of the file is not equal. File " + localFile + " will be deleted. Size = " + localFile.length() / 1024L / 1024L);
                Files.delete(localFile.toPath());
                continue;
            }
            listRes.add(meta);
        }
        this.repo.setResources(listRes);
        this.repo.setRepositories(repo.getRepositories());
    }

    public void containerAllSize(Repo repo) {
        this.containerSize = repo.getResources().stream().map(Metadata::getSize).reduce(Long::sum).orElse(0L);
    }

    public String getDestinationRepositories() {
        return this.destinationRepositories;
    }

    public long getContainerSize() {
        return this.containerSize;
    }

    public Repo getRepo() {
        return this.repo;
    }

    public List<PostHandler> getHandlers() {
        return this.handlers;
    }

    public void setDestinationRepositories(String destinationRepositories) {
        this.destinationRepositories = destinationRepositories;
    }

    public void setContainerSize(long containerSize) {
        this.containerSize = containerSize;
    }

    public void setRepo(Repo repo) {
        this.repo = repo;
    }

    public void setHandlers(List<PostHandler> handlers) {
        this.handlers = handlers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloaderContainer)) {
            return false;
        }
        DownloaderContainer other = (DownloaderContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerSize() != other.getContainerSize()) {
            return false;
        }
        String this$destinationRepositories = this.getDestinationRepositories();
        String other$destinationRepositories = other.getDestinationRepositories();
        if (this$destinationRepositories == null ? other$destinationRepositories != null : !this$destinationRepositories.equals(other$destinationRepositories)) {
            return false;
        }
        Repo this$repo = this.getRepo();
        Repo other$repo = other.getRepo();
        if (this$repo == null ? other$repo != null : !((Object)this$repo).equals(other$repo)) {
            return false;
        }
        List<PostHandler> this$handlers = this.getHandlers();
        List<PostHandler> other$handlers = other.getHandlers();
        return !(this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloaderContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $containerSize = this.getContainerSize();
        result = result * 59 + (int)($containerSize >>> 32 ^ $containerSize);
        String $destinationRepositories = this.getDestinationRepositories();
        result = result * 59 + ($destinationRepositories == null ? 43 : $destinationRepositories.hashCode());
        Repo $repo = this.getRepo();
        result = result * 59 + ($repo == null ? 43 : ((Object)$repo).hashCode());
        List<PostHandler> $handlers = this.getHandlers();
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        return result;
    }

    public String toString() {
        return "DownloaderContainer(destinationRepositories=" + this.getDestinationRepositories() + ", containerSize=" + this.getContainerSize() + ", repo=" + this.getRepo() + ", handlers=" + this.getHandlers() + ")";
    }
}

