/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.injection;

import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.tlauncher.injection.InjectionManager;
import org.tlauncher.injection.InjectionResult;
import org.tlauncher.injection.MethodDescFilter;
import org.tlauncher.injection.mapping.MappingManager;
import org.tlauncher.injection.mapping.Mappings;
import org.tlauncher.injection.mapping.ObfClass;
import org.tlauncher.tweaker.Tweaker;
import org.tlauncher.util.TLModCfg;

public class Injections {
    void registerInjections(InjectionManager injectionManager) {
        Mappings mappings = MappingManager.instance().getMappings();
        ObfClass abstractClientPlayer = mappings.getClass("AbstractClientPlayer");
        ObfClass entityPlayer = mappings.getClass("Player");
        String resourceLocation = mappings.getClass("ResourceLocation").getObfName();
        String locCapeMethodName = abstractClientPlayer.getMethod("getCloakTextureLocation").getObfName();
        String abstrPlayerClassName = abstractClientPlayer.getObfName();
        String locSkinMethodName = abstractClientPlayer.getMethod("getSkinTextureLocation").getObfName();
        String skinTypeMethodName = abstractClientPlayer.getMethod("getModelName").getObfName();
        String locElytraMethodName = abstractClientPlayer.getMethod("getElytraTextureLocation").getObfName();
        String getGameProfileMethodName = entityPlayer.getMethod("getGameProfile").getObfName();
        String resourceLocationDesc = String.format("()L%s;", resourceLocation);
        ObfClass guiMainMenu = mappings.getClass("TitleScreen");
        injectionManager.addInjection("TitleScreen", guiMainMenu.getObfName(), (bytes, injectionHelper) -> {
            String descriptor = TLModCfg.getMinecraftVersion().isGreaterThanOrEquals("1.20") ? String.format("(L%s;IIF)V", mappings.getClass("GuiGraphics").getObfName()) : String.format("(L%s;IIF)V", mappings.getClass("PoseStack").getObfName());
            return injectionHelper.init(bytes).findMethod(guiMainMenu.getMethod("render").getObfName(), descriptor).thenApply(methodNodeWrap -> {
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new InsnNode(4));
                insnList.add((AbstractInsnNode)new FieldInsnNode(179, "org/tlauncher/Variables", "isLoaded", "Z"));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "onMainMenuRender", "()V", false));
                methodNodeWrap.getInstructions().insert(methodNodeWrap.getInstructions().getFirst(), insnList);
                return InjectionResult.SUCCESS;
            });
        });
        if (!TLModCfg.isOptiFineDetected()) {
            String gameMainClass = "net.minecraft.client.main.Main";
            injectionManager.addInjection("MainArgs", "net.minecraft.client.main.Main", (bytes, injectionHelper) -> injectionHelper.init(bytes).findMethod("main", "([Ljava/lang/String;)V").thenApply(methodNodeWrap -> {
                methodNodeWrap.findInstruction().filter(abstractInsnNode -> abstractInsnNode instanceof MethodInsnNode).map(abstractInsnNode -> (MethodInsnNode)abstractInsnNode).filter(methodInsnNode -> methodInsnNode.owner.equals("joptsimple/OptionParser")).filter(methodInsnNode -> methodInsnNode.name.equals("<init>")).findFirst().ifPresent(methodInsnNode -> {
                    methodInsnNode.desc = "(Z)V";
                    methodNodeWrap.getInstructions().insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new InsnNode(3));
                });
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "processMainArgs", "([Ljava/lang/String;)[Ljava/lang/String;", false));
                list.add((AbstractInsnNode)new VarInsnNode(58, 0));
                methodNodeWrap.getInstructions().insertBefore(methodNodeWrap.getInstructions().getFirst(), list);
                return InjectionResult.SUCCESS;
            }));
        }
        this.injectConnector(injectionManager, mappings);
        if (TLModCfg.getMinecraftVersion().isGreaterThanOrEquals("1.20.2")) {
            ObfClass playerSkin = mappings.getClass("PlayerSkin");
            ObfClass playerInfo = mappings.getClass("PlayerInfo");
            String playerInfoClassName = playerInfo.getObfName();
            String getSkinMethodName = playerInfo.getMethod("getSkin").getObfName();
            String gameProfileMethodName = playerInfo.getMethod("getProfile").getObfName();
            injectionManager.addInjection("PlayerInfo", playerInfoClassName, (bytes, injectionHelper) -> {
                ArrayList injectionResults = new ArrayList();
                injectionHelper.init(bytes, 0, 1).findMethod(getSkinMethodName, String.format("()L%s;", playerSkin.getObfName())).thenAccept(methodNodeWrap -> {
                    if (!Tweaker.isTLSkinCapeEnabled) {
                        return;
                    }
                    methodNodeWrap.getInstructions().remove(methodNodeWrap.getInstructions().get(0));
                    methodNodeWrap.getInstructions().remove(methodNodeWrap.getInstructions().get(0));
                    methodNodeWrap.getInstructions().remove(methodNodeWrap.getInstructions().get(methodNodeWrap.getInstructions().size() - 1));
                    methodNodeWrap.getInstructions().remove(methodNodeWrap.getInstructions().get(methodNodeWrap.getInstructions().size() - 1));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(184, "java/util/Objects", "requireNonNullElse", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new TypeInsnNode(192, playerSkin.getObfName()));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new InsnNode(176));
                    InsnList list = new InsnList();
                    list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    list.add((AbstractInsnNode)new MethodInsnNode(182, playerInfoClassName, gameProfileMethodName, "()Lcom/mojang/authlib/GameProfile;", false));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "getPlayerSkin", "(Lcom/mojang/authlib/GameProfile;)Ljava/lang/Object;", false));
                    methodNodeWrap.getInstructions().insert(list);
                    injectionResults.add(InjectionResult.SUCCESS);
                });
                for (Object injectionResult : injectionResults) {
                    if (injectionResult == InjectionResult.SUCCESS) continue;
                    return InjectionResult.FAILURE;
                }
                return InjectionResult.SUCCESS;
            });
        } else {
            injectionManager.addInjection("AbstractClientPlayer", abstrPlayerClassName, (bytes, injectionHelper) -> {
                ArrayList injectionResults = new ArrayList();
                injectionHelper.init(bytes).findMethod(locCapeMethodName, resourceLocationDesc).thenAccept(methodNodeWrap -> {
                    if (!Tweaker.isTLSkinCapeEnabled) {
                        return;
                    }
                    methodNodeWrap.getInstructions().clear();
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new VarInsnNode(25, 0));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(182, abstrPlayerClassName, getGameProfileMethodName, "()Lcom/mojang/authlib/GameProfile;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "getLocationCape", String.format("(Lcom/mojang/authlib/GameProfile;)L%s;", resourceLocation), false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new InsnNode(176));
                    injectionResults.add(InjectionResult.SUCCESS);
                }).findMethod(locSkinMethodName, resourceLocationDesc).thenAccept(methodNodeWrap -> {
                    if (!Tweaker.isTLSkinCapeEnabled) {
                        return;
                    }
                    methodNodeWrap.getInstructions().clear();
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new VarInsnNode(25, 0));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(182, abstrPlayerClassName, getGameProfileMethodName, "()Lcom/mojang/authlib/GameProfile;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "getLocationSkin", String.format("(Lcom/mojang/authlib/GameProfile;)L%s;", resourceLocation), false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new InsnNode(176));
                    injectionResults.add(InjectionResult.SUCCESS);
                }).findMethod(locElytraMethodName, resourceLocationDesc).nonNull().thenAccept(methodNodeWrap -> {
                    if (!Tweaker.isTLSkinCapeEnabled) {
                        return;
                    }
                    methodNodeWrap.getInstructions().clear();
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new VarInsnNode(25, 0));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(182, abstrPlayerClassName, getGameProfileMethodName, "()Lcom/mojang/authlib/GameProfile;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "getLocationElytra", String.format("(Lcom/mojang/authlib/GameProfile;)L%s;", resourceLocation), false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new InsnNode(176));
                    injectionResults.add(InjectionResult.SUCCESS);
                }).findMethod(skinTypeMethodName, "()Ljava/lang/String;").thenAccept(methodNodeWrap -> {
                    if (!Tweaker.isTLSkinCapeEnabled) {
                        return;
                    }
                    methodNodeWrap.getInstructions().clear();
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new VarInsnNode(25, 0));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(182, abstrPlayerClassName, getGameProfileMethodName, "()Lcom/mojang/authlib/GameProfile;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "getSkinType", "(Lcom/mojang/authlib/GameProfile;)Ljava/lang/String;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new InsnNode(176));
                    injectionResults.add(InjectionResult.SUCCESS);
                });
                for (InjectionResult injectionResult : injectionResults) {
                    if (injectionResult == InjectionResult.SUCCESS) continue;
                    return InjectionResult.FAILURE;
                }
                return InjectionResult.SUCCESS;
            });
        }
        if (TLModCfg.getMinecraftVersion().isLowerThanOrEquals("1.21.1")) {
            ObfClass playerModel = mappings.getClass("PlayerModel");
            injectionManager.addInjection("PlayerModel", playerModel.getObfName(), (bytes, injectionHelper) -> injectionHelper.init(bytes).findMethod(playerModel.getMethod("renderCloak").getObfName(), MethodDescFilter.builder().endsWith(";II)V").build()).thenApply(methodNodeWrap -> {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "preRenderCape", "()V", false));
                methodNodeWrap.getInstructions().insertBefore(methodNodeWrap.getInstructions().getFirst(), list);
                return InjectionResult.SUCCESS;
            }));
        }
    }

    private void injectConnector(InjectionManager injectionManager, Mappings mappings) {
        String minecraftClassName = mappings.getClass("Minecraft").getObfName();
        if (!TLModCfg.isOptiFineDetected()) {
            if (!TLModCfg.getMinecraftVersion().isGreaterThanOrEquals("1.20.6")) {
                injectionManager.addInjection("MainInit", minecraftClassName, (bytes, injectionHelper) -> {
                    injectionHelper.init(bytes).findMethod("<init>").forEach(objectMethodNodeContainer -> objectMethodNodeContainer.thenAccept(methodNodeWrap -> {
                        AbstractInsnNode instruction = methodNodeWrap.findInstruction(node -> node instanceof MethodInsnNode && ((MethodInsnNode)node).name.equals("<init>"));
                        InsnList list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list.add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "startConnector", String.format("(L%s;)V", minecraftClassName), false));
                        methodNodeWrap.getInstructions().insert(instruction, list);
                    }));
                    return InjectionResult.SUCCESS;
                });
            } else {
                String tutorialClass = mappings.getClass("Tutorial").getObfName();
                injectionManager.addInjection("Tutorial", tutorialClass, (bytes, injectionHelper) -> injectionHelper.init(bytes).findMethod("<init>").get(0).thenApply(methodNodeWrap -> {
                    AbstractInsnNode instruction = methodNodeWrap.findInstruction(node -> node instanceof FieldInsnNode && ((FieldInsnNode)node).desc.equals("L" + minecraftClassName + ";"));
                    InsnList list = new InsnList();
                    list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "startConnector", String.format("(L%s;)V", minecraftClassName), false));
                    methodNodeWrap.getInstructions().insert(instruction, list);
                    return InjectionResult.SUCCESS;
                }));
            }
        }
    }
}

