/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.tlauncher.TLSkinCape;
import org.tlauncher.model.PlayerName;
import org.tlauncher.model.ProfileTexture;
import org.tlauncher.renderer.TextureManager;
import org.tlauncher.util.reflection.ResourceLocationUtils;

public class PlayerSkinManager {
    private static final PlayerSkin[] DEFAULT_SKINS = new PlayerSkin[]{PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/alex.png", PlayerSkin.Model.SLIM), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/ari.png", PlayerSkin.Model.SLIM), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/efe.png", PlayerSkin.Model.SLIM), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/kai.png", PlayerSkin.Model.SLIM), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/makena.png", PlayerSkin.Model.SLIM), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/noor.png", PlayerSkin.Model.SLIM), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/steve.png", PlayerSkin.Model.SLIM), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/sunny.png", PlayerSkin.Model.SLIM), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/zuri.png", PlayerSkin.Model.SLIM), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/alex.png", PlayerSkin.Model.WIDE), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/ari.png", PlayerSkin.Model.WIDE), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/efe.png", PlayerSkin.Model.WIDE), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/kai.png", PlayerSkin.Model.WIDE), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/makena.png", PlayerSkin.Model.WIDE), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/noor.png", PlayerSkin.Model.WIDE), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/steve.png", PlayerSkin.Model.WIDE), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/sunny.png", PlayerSkin.Model.WIDE), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/zuri.png", PlayerSkin.Model.WIDE)};
    private final TLSkinCape tlSkinCape;
    private final TextureManager textureManager;
    private final Map<PlayerName, PlayerDynamicSkin> playerSkins = new ConcurrentHashMap<PlayerName, PlayerDynamicSkin>();
    private final List<PlayerSkin> emptySkins = Collections.unmodifiableList(new ArrayList());

    public PlayerSkin getPlayerSkin(GameProfile gameProfile, PlayerName playerName) {
        ProfileTexture profileTexture;
        boolean isSkinInit = this.textureManager.isInit(playerName, MinecraftProfileTexture.Type.SKIN);
        boolean isCapeInit = this.textureManager.isInit(playerName, MinecraftProfileTexture.Type.CAPE);
        PlayerDynamicSkin result = this.playerSkins.get(playerName);
        if (!isSkinInit || !isCapeInit) {
            if (this.tlSkinCape.createTexture(gameProfile, playerName)) {
                TLSkinCape.LOGGER.debug("TEXTURES creation started for PN:{} ||||| GP:{}", (Object)playerName, (Object)gameProfile);
            }
            return this.getRandomPlayerSkin(gameProfile);
        }
        if (result == null) {
            PlayerDynamicSkin skins;
            profileTexture = this.textureManager.get(playerName);
            if (profileTexture == null) {
                return this.getRandomPlayerSkin(gameProfile);
            }
            TLSkinCape.LOGGER.debug("LOADING GM:{} |||| PN:{}", (Object)gameProfile, (Object)playerName);
            result = skins = this.extractPlayerSkins(profileTexture);
            this.playerSkins.put(playerName, result);
        } else {
            profileTexture = this.textureManager.get(playerName);
            if (result.playerSkin() != null && !Objects.equals(result.playerSkin(), profileTexture.getSkin())) {
                this.playerSkins.remove(playerName);
                return this.getRandomPlayerSkin(gameProfile);
            }
        }
        if (profileTexture != null && profileTexture.getCape() != null) {
            if (profileTexture.getCape().getFrames().size() == 1) {
                return result.dynamicSkins().get(0);
            }
            profileTexture.getCape().getFrame();
            return result.dynamicSkins().get(profileTexture.getCape().getCurrentFrameIndex());
        }
        if (!result.dynamicSkins().isEmpty()) {
            return result.dynamicSkins().get(0);
        }
        return this.getRandomPlayerSkin(gameProfile);
    }

    private PlayerDynamicSkin extractPlayerSkins(ProfileTexture profileTexture) {
        if (profileTexture.getSkin() == null) {
            return new PlayerDynamicSkin(null, this.emptySkins);
        }
        PlayerSkin.Model model = "slim".equals(profileTexture.getSkinType()) ? PlayerSkin.Model.SLIM : PlayerSkin.Model.WIDE;
        ArrayList<PlayerSkin> skins = new ArrayList<PlayerSkin>();
        boolean secure = false;
        if (profileTexture.getCape() != null) {
            for (ResourceLocation frame : profileTexture.getCape().getFrames()) {
                skins.add(new PlayerSkin(profileTexture.getSkin(), null, frame, (ResourceLocation)(profileTexture.isHasElytra() ? frame : null), model, secure));
            }
        } else {
            skins.add(new PlayerSkin(profileTexture.getSkin(), null, null, null, model, secure));
        }
        return new PlayerDynamicSkin(profileTexture.getSkin(), skins);
    }

    private PlayerSkin getRandomPlayerSkin(GameProfile gameProfile) {
        return DEFAULT_SKINS[Math.floorMod(gameProfile.getId().hashCode(), DEFAULT_SKINS.length)];
    }

    private static PlayerSkin createDefaultPlayerSkin(String path, PlayerSkin.Model model) {
        return new PlayerSkin(ResourceLocationUtils.resourceLocation(path), null, null, null, model, true);
    }

    public PlayerSkinManager(TLSkinCape tlSkinCape, TextureManager textureManager) {
        this.tlSkinCape = tlSkinCape;
        this.textureManager = textureManager;
    }

    private record PlayerDynamicSkin(ResourceLocation playerSkin, List<PlayerSkin> dynamicSkins) {
    }
}

