/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.common.entity.Rhino;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class RhinoModel
extends GeoModel<Rhino> {
    public ResourceLocation getModelResource(Rhino rhino) {
        return new ResourceLocation("naturalist", "geo/entity/rhino.geo.json");
    }

    public ResourceLocation getTextureResource(Rhino rhino) {
        return new ResourceLocation("naturalist", "textures/entity/rhino.png");
    }

    public ResourceLocation getAnimationResource(Rhino rhino) {
        return new ResourceLocation("naturalist", "animations/rhino.rp_anim.json");
    }

    public void setCustomAnimations(@NotNull Rhino entity, long instanceId, AnimationState<Rhino> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        if (animationState == null) {
            return;
        }
        EntityModelData extraDataOfType = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone bigHorn = this.getAnimationProcessor().getBone("big_horn");
        CoreGeoBone smallHorn = this.getAnimationProcessor().getBone("small_horn");
        CoreGeoBone babyHorn = this.getAnimationProcessor().getBone("baby_horn");
        CoreGeoBone leftEar = this.getAnimationProcessor().getBone("left_ear");
        CoreGeoBone rightEar = this.getAnimationProcessor().getBone("right_ear");
        if (entity.m_6162_()) {
            head.setScaleX(1.4f);
            head.setScaleY(1.4f);
            head.setScaleZ(1.4f);
            leftEar.setScaleX(1.1f);
            leftEar.setScaleY(1.1f);
            leftEar.setScaleZ(1.1f);
            rightEar.setScaleX(1.1f);
            rightEar.setScaleY(1.1f);
            rightEar.setScaleZ(1.1f);
        } else {
            head.setScaleX(1.0f);
            head.setScaleY(1.0f);
            head.setScaleZ(1.0f);
            leftEar.setScaleX(1.0f);
            leftEar.setScaleY(1.0f);
            leftEar.setScaleZ(1.0f);
            rightEar.setScaleX(1.0f);
            rightEar.setScaleY(1.0f);
            rightEar.setScaleZ(1.0f);
        }
        if (!entity.m_20142_()) {
            head.setRotY(extraDataOfType.netHeadYaw() * ((float)Math.PI / 180));
        }
        bigHorn.setHidden(entity.m_6162_());
        smallHorn.setHidden(entity.m_6162_());
        babyHorn.setHidden(!entity.m_6162_());
    }
}

