/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.inventory.CommonFluid;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BackpackTooltipComponent
implements TooltipComponent {
    protected List<ItemStack> storage = new ArrayList<ItemStack>();
    protected List<ItemStack> upgrades = new ArrayList<ItemStack>();
    protected List<ItemStack> tools = new ArrayList<ItemStack>();
    protected FluidStack leftFluidStack = CommonFluid.empty();
    protected FluidStack rightFluidStack = CommonFluid.empty();
    protected final boolean hoveredWithItem;

    public BackpackTooltipComponent(ItemStack stack) {
        this(stack, false);
    }

    public BackpackTooltipComponent(ItemStack stack, boolean hoveredWithItem) {
        this.loadComponentData(stack);
        this.hoveredWithItem = hoveredWithItem;
    }

    public boolean isHoveredWithItem() {
        return this.hoveredWithItem;
    }

    public void loadComponentData(ItemStack stack) {
        this.loadFluidStacks(stack);
        this.storage = this.loadStorage(stack);
        this.upgrades = this.loadUpgrades(stack);
        this.storage = this.mergeStacks(this.storage);
        this.tools = this.loadTools(stack);
    }

    public void loadFluidStacks(ItemStack stack) {
        if (NbtHelper.has(stack, "RenderInfo")) {
            RenderInfo info = (RenderInfo)NbtHelper.get(stack, "RenderInfo");
            this.leftFluidStack = info.getLeftFluidStack();
            this.rightFluidStack = info.getRightFluidStack();
        }
    }

    public List<ItemStack> loadStorage(ItemStack stack) {
        if (NbtHelper.has(stack, "Inventory")) {
            return new ArrayList<ItemStack>(((NonNullList)NbtHelper.get(stack, "Inventory")).stream().filter(itemStack -> !itemStack.m_41619_()).toList());
        }
        return new ArrayList<ItemStack>();
    }

    public List<ItemStack> loadUpgrades(ItemStack stack) {
        if (NbtHelper.has(stack, "Upgrades")) {
            return new ArrayList<ItemStack>(((NonNullList)NbtHelper.get(stack, "Upgrades")).stream().filter(itemStack -> !itemStack.m_41619_()).toList());
        }
        return new ArrayList<ItemStack>();
    }

    public List<ItemStack> mergeStacks(List<ItemStack> stacks) {
        if (!stacks.isEmpty()) {
            ArrayList<ItemStack> uniqueList = new ArrayList<ItemStack>();
            for (ItemStack stack : stacks) {
                if (uniqueList.isEmpty()) {
                    uniqueList.add(stack);
                    continue;
                }
                boolean flag = false;
                for (int i = 0; i < uniqueList.size(); ++i) {
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)uniqueList.get(i)))) continue;
                    int count = stack.m_41613_() + ((ItemStack)uniqueList.get(i)).m_41613_();
                    uniqueList.set(i, stack.m_255036_(count));
                    flag = true;
                    break;
                }
                if (flag) continue;
                uniqueList.add(stack);
            }
            ArrayList<ItemStack> splittedList = new ArrayList<ItemStack>();
            for (ItemStack itemStack : uniqueList) {
                if (itemStack.m_41613_() > 999) {
                    int count = itemStack.m_41613_();
                    int c = count / 999;
                    int reminder = count % 999;
                    for (int j = 0; j < c; ++j) {
                        splittedList.add(itemStack.m_255036_(999));
                    }
                    splittedList.add(itemStack.m_255036_(reminder));
                    continue;
                }
                splittedList.add(itemStack);
            }
            return splittedList;
        }
        return new ArrayList<ItemStack>();
    }

    public List<ItemStack> loadTools(ItemStack stack) {
        if (NbtHelper.has(stack, "ToolsInventory")) {
            return new ArrayList<ItemStack>(((NonNullList)NbtHelper.get(stack, "ToolsInventory")).stream().filter(itemStack -> !itemStack.m_41619_()).toList());
        }
        return new ArrayList<ItemStack>();
    }
}

